#ifndef __DM_CONSOLE_H__
#define __DM_CONSOLE_H__

////////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

#define DM_CONSOLE_QUEUE_COUNT_MAX         10
#define DM_MAX_CMD_NAME_LEN                18
#define DM_MAX_CMD_HELP_LEN                32
#define DM_MAX_USER_CMD_LEN                (80+1)
////////////////////////////////////////////////////////////////////////////////

typedef INT32 (*CMDFUNC)(UINT32 param, char * cmd);
// callback functions for sending data
typedef void (*SENDFUNC)(UINT8 * psrc, UINT32 len, UINT32 param);
//typedef void (*SECHOFUNC)(BOOL, UINT32 param);
//typedef BOOL (*GECHOFUNC)(UINT32 param);
typedef void (*CAPTFUNC)(void);
typedef void (*RELFUNC)(void);
typedef void (*PF_DM_ETHSW_HW_RESET)( void );
extern PF_DM_ETHSW_HW_RESET g_pEthernetSwitchHardwareResetFunc;
////////////////////////////////////////////////////////////////////////////////

// table of console commands
typedef struct
{
    char name[DM_MAX_CMD_NAME_LEN] ;
    UINT16 match;                         // chars to match for name
    CMDFUNC func_call;
    INT32 level;                         // used to differentiate similiar but different cmds
    UINT16 help_menu;                   // indicates in which menu of help command is shown
    char help_str[DM_MAX_CMD_HELP_LEN] ;
    UINT32 caller_banned;
} CMDTABLE;

typedef struct
{
    char name[DM_MAX_CMD_NAME_LEN] ;
    UINT16 match;                         // chars to match for name
    CMDFUNC func_call;
} DEBUGCMDTABLE;

typedef struct
{
    UINT8 length;        // length of command string;
    void *pCmdInput;     // Need a pointer to parent as this is sent by value.
    char commandString[DM_MAX_USER_CMD_LEN];
} CMDSTRUCT;

typedef struct _CMDINPUT
{
    UINT8     echo;
    //UINT8     canBeCaptured;
    UINT8     captured;
    UINT16    cmdSource;
    UINT8     consolePasswordVerified;
    UINT8     enteringPassword;
    UINT8     passwordMask;
    UINT8     printLock;
    //void * pActiveSocket;
    //void * command;
    SENDFUNC pSendFunc;
    UINT32  sendParam;
    //SECHOFUNC pSetEchoFunc;
    //GECHOFUNC pGetEchoFunc;
    CAPTFUNC pCaptureFunc;
    RELFUNC pReleaseFunc;
    CMDSTRUCT command;
    UINT8 txBuf[DM_MAX_USER_CMD_LEN];
    UINT8 rxBuf[DM_MAX_USER_CMD_LEN];
    UINT8 rxBufBytes;
    BOOL killMe;
    UINT32 TjiPrintLock;
    UINT32 consoleLock;
    struct _CMDINPUT    *pPassto;
} CMDINPUT;

////////////////////////////////////////////////////////////////////////////////

// PEM - try to put commands.h stuff in here too
extern void DmConsoleNPuts(char *src, UINT16 length) ;
extern void DmConsolePuts(char *src);
#if defined(__GNUC__)
    extern void DmConsolePrintf(const char *format, ...) __attribute__ ((format (printf, 1, 2)));
    // See dm_errors.h DM_ERROR_LEVEL for severity levels.
    extern void DmConsoleLevelPrintf(UINT8 severity, const char *format, ...) __attribute__ ((format (printf, 2, 3)));
#else
    extern void DmConsolePrintf(char *format, ...);
    // See dm_errors.h DM_ERROR_LEVEL for severity levels.
    extern void DmConsoleLevelPrintf(UINT8 severity, const char *format, ...);
#endif
extern void DmUARTConsolePrintf(char *format, ...);
extern void DmConsolePrintError( UINT8 level, UINT8 subsystem, UINT8 errCode, UINT16 causeCode );
extern char * DmConsoleGetPrompt(void);
extern INT32 DmConsoleSendCommandToTask(CMDSTRUCT * pCommand);
extern void CmdInputAddToList(CMDINPUT *pCmdInput);
extern void DmConsoleShowPrompt(void);
extern void DmConsoleHexDumpPacket(UINT8 * pPkt, UINT16 len, char * msg, BOOL showAscii);
extern void DmConsoleDisplayWelcome(CMDINPUT * pCmdInput);
extern UINT32 DmConsoleBufferInput(CMDINPUT * pCmdInput, UINT8 newChar);
extern BOOL DmConsoleIsLocal(void);
extern void DmConsoleGetUserResponse(char *prompt, char *ResponseString, UINT32 MaxLength);
extern void DmConsoleSetEcho(BOOL);
extern BOOL DmConsoleGetEcho(void);
extern void ShowHelpMenu(UINT32);
UINT8 DmConsoleTjiPrintLock(void);
void DmConsoleTjiPrintUnlock(void);
#ifdef __cplusplus
extern void DmConsoleInit(UINT32 lStackSize = 0);
#endif
extern void UartConsoleInit(void);
extern UINT8 IsUartConsoleInit(void);
extern UINT32 UartConsoleIsr(UINT32 inst, BOOL gotBreak, BOOL rxReady, UINT8 newByte, BOOL txEmpty);
extern void UartConsoleTx(UINT8 *data, UINT32 count, UINT32 inst);
extern void UartNoConsoleTx(UINT8 *data, UINT32 count, UINT32 inst) ;
extern void UartConsoleMsg(const char *msg);

extern BOOL DmConsoleWaitBufferAvailable(CMDINPUT * pCmdInput, UINT16 sTimeout);
extern const CMDTABLE CommandTable[];
extern const DEBUGCMDTABLE DebugCommandTable[];
extern CMDTABLE *AltCommandTable;
extern CMDINPUT * DmGetCurrentConsole( void );
extern void  DmConsoleCloseInput( CMDINPUT *pCmdInput );
extern void  DmConsolePassto(CMDINPUT *pCmdPassto);

typedef void (*PTNQXMODPKT)(unsigned char * dataptr, int len);
extern PTNQXMODPKT pfPTNQXmodemPacket;

typedef void (*PTSCKTCLSD)(void);
extern PTSCKTCLSD pfPTSocketClosed;

////////////////////////////////////////////////////////////////////////////////

typedef struct
{
    UINT32 bps;
	UINT8 *pTxBuffer;	// pointer to data to transmit
	UINT16	charIdx;	// index of next character to transmit
	UINT16 msgLen;		// message length
	volatile BOOL TxDone;	//
    CMDINPUT cmdInput;
}UARTCONSOLE;

typedef struct
{
    CMDINPUT cmdInput;
}USBCONSOLE;

typedef struct
{
    CMDINPUT cmdInput;
} PCCONSOLE;

extern UARTCONSOLE UartConsole;
extern USBCONSOLE USBConsole;
extern PCCONSOLE    PcConsole;

#ifdef DM_V24
extern int V24ErroLog(char *format, ...);
#endif

#ifdef DM_WINCE
//CrestCoreWinCE variables
extern BOOL g_bCommandResponseEnabled;
extern DWORD g_lCommandResponseTransId;
#endif

#ifdef __cplusplus
}
#endif

#endif  //__DM_CONSOLE_H__


